<?php
/**
 * Class DimensionalWeight
 */

namespace WPDesk\FS\TableRate\Rule\Condition\Pro;

use WPDesk\FS\TableRate\Rule\Condition\AbstractCondition;

/**
 * Dimensional Weight condition.
 */
class DimensionalWeight extends AbstractCondition {

	const CONDITION_ID = 'dimensional_weight';

	/**
	 * Product constructor.
	 *
	 * @param int $priority .
	 */
	public function __construct( int $priority = 10 ) {
		$this->condition_id = self::CONDITION_ID;
		$this->name         = __( 'Dimensional weight', 'flexible-shipping' );
		$this->group        = __( 'Weight & Dimensions', 'flexible-shipping' );
		$this->priority     = $priority;
		$this->is_disabled  = true;

		$this->name .= ' ' . __( '(PRO feature)', 'flexible-shipping' );
	}
}
